<?php

defined('_JEXEC') or die;

jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');

$version = new JVersion();
if ('1.5' != $version->RELEASE) {
	JError::raiseError(500, "This patch is for Joomla! 1.5.x only");
}

$app    = JFactory::getApplication();
$parent = $this->parent;
$source = $parent->getPath('source');

$files = array(
	'file.php' => array(
		'path'     => '/libraries/joomla/filesystem'
	,	'old'      => '7a06b1674f30d36521f4755f3438acaf'
	,	'checksum' => '0eabdf91e2c7a26493eeb3dbe7a3fb39'
	)
,	'media.php' => array(
		'path'     => '/administrator/components/com_media/helpers'
	,	'old'      => '8ee5fd1f0d70d0a3b00006aa35267afe'
	,	'checksum' => '3de2ea3338d49956b5dabf3a3fa1200d'
	)
);

foreach ($files as $file => $data) {
	if (!file_exists("$source/files/patch/$file")) {
		JError::raiseError(500, "Cannot find source in $source!");
	}
	$dest = JPATH_ROOT . $data['path'] . "/$file";
	if (!file_exists($dest)) {
		JError::raiseError(500, "Cannot find destination file $file!");
	}
	if (md5_file($dest) != $data['old']) {
		if (md5_file($dest) != $data['checksum']) {
			$app->enqueueMessage("Checksum for existing $file does not match!", "error");
		}
		else {
			$app->enqueueMessage("Checksum for existing $file matches patch file - not overwriting");
		}
		continue;
	}
	JFile::copy("$source/files/patch/$file", $dest);
	if (md5_file($dest) != $data['checksum']) {
		$app->enqueueMessage("Checksum for new $file does not match!", "error");
	}
}

class SecPatchCleanup
{
	function __destruct() {
		$com = 'com_joomla1.5.26-31626patch';
		JFolder::delete(JPATH_ROOT . '/administrator/components/' . $com);
		$db = JFactory::getDbo();
		$db->setQuery('DELETE FROM `#__components` WHERE `option` = ' . $db->Quote($com));
		$db->query();
	}
}

$x = new SecPatchCleanup();
